/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.filter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.quest.filter.HostileMobsFilter;
import dev.toma.gunsrpg.common.quests.quest.filter.IEntityFilter;
import dev.toma.gunsrpg.common.quests.quest.filter.SpecificEntityFilter;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class EntityFilterType<F extends IEntityFilter> {
    private static final Map<ResourceLocation, EntityFilterType<?>> MAP = new HashMap();
    public static final EntityFilterType<IEntityFilter> ANY = new EntityFilterType<IEntityFilter>(GunsRPG.makeResource("any"), new AnyEntityFilterSerializer());
    public static final EntityFilterType<SpecificEntityFilter> SPECIFIC = new EntityFilterType<SpecificEntityFilter>(GunsRPG.makeResource("specific_entity"), new SpecificEntityFilter.Serializer());
    public static final EntityFilterType<HostileMobsFilter> HOSTILE = new EntityFilterType<HostileMobsFilter>(GunsRPG.makeResource("hostile"), new HostileMobsFilter.Serializer());
    private final ResourceLocation id;
    private final Serializer<F> serializer;

    public EntityFilterType(ResourceLocation id, Serializer<F> serializer) {
        this.id = id;
        this.serializer = serializer;
        MAP.put(id, this);
    }

    public static <F extends IEntityFilter> F any() {
        return (F)AnyEntityFilterSerializer.ANY;
    }

    public static <F extends IEntityFilter> EntityFilterType<F> getType(ResourceLocation id) {
        return MAP.get(id);
    }

    public Serializer<F> getSerializer() {
        return this.serializer;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public static <F extends IEntityFilter> F resolveJsonFile(JsonElement element) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(element);
        ResourceLocation type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"type"));
        EntityFilterType<F> filterType = EntityFilterType.getType(type);
        if (filterType == null) {
            throw new JsonSyntaxException("Unknown entity filter: " + type);
        }
        Serializer<F> serializer = filterType.getSerializer();
        return serializer.resolveFile(filterType, (JsonElement)object);
    }

    public static <F extends IEntityFilter> CompoundNBT serializeNbt(F filter) {
        CompoundNBT nbt = new CompoundNBT();
        EntityFilterType<?> type = filter.getType();
        nbt.func_74778_a("type", type.getId().toString());
        type.getSerializer().toNbt(filter, nbt);
        return nbt;
    }

    @Nullable
    public static <F extends IEntityFilter> F deserializeNbt(CompoundNBT nbt) {
        ResourceLocation type = new ResourceLocation(nbt.func_74779_i("type"));
        EntityFilterType<F> filterType = EntityFilterType.getType(type);
        if (filterType == null) {
            return EntityFilterType.any();
        }
        return filterType.getSerializer().fromNbt(filterType, nbt);
    }

    private static final class AnyEntityFilterSerializer
    implements Serializer<IEntityFilter> {
        static final IEntityFilter ANY = new IEntityFilter(){

            @Override
            public EntityFilterType<?> getType() {
                return EntityFilterType.ANY;
            }

            @Override
            public boolean test(Entity entity) {
                return true;
            }

            public String toString() {
                return "Any";
            }
        };

        private AnyEntityFilterSerializer() {
        }

        @Override
        public IEntityFilter resolveFile(EntityFilterType<IEntityFilter> type, JsonElement json) throws JsonParseException {
            return ANY;
        }

        @Override
        public void toNbt(IEntityFilter filter, CompoundNBT nbt) {
        }

        @Override
        public IEntityFilter fromNbt(EntityFilterType<IEntityFilter> filterType, CompoundNBT nbt) {
            return ANY;
        }
    }

    public static interface Serializer<F extends IEntityFilter> {
        public F resolveFile(EntityFilterType<F> var1, JsonElement var2) throws JsonParseException;

        public void toNbt(F var1, CompoundNBT var2);

        public F fromNbt(EntityFilterType<F> var1, CompoundNBT var2);
    }
}

